---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：44-MAC（Mandatory Access Control）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **エラー合成演算子の詳細ロジック**：複数ポリシー結果合成の具体的実装確認が必要
  2. **各ポリシーモジュールの完全な機能一覧**：全ポリシーモジュールの網羅性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/security/mac/mac_framework.c` - MACフレームワーク中核（45-67行目コメント確認）
- E-02: `sys/security/mac_biba/` - Bibaポリシーディレクトリ確認
- E-03: `sys/security/mac_mls/` - MLSポリシーディレクトリ確認
- E-04: `sys/security/mac_bsdextended/` - bsdextendedディレクトリ確認
- E-05: `sys/security/mac_seeotheruids/` - seeotheruidsディレクトリ確認
- E-06: `sys/security/mac_portacl/` - portaclディレクトリ確認
- E-07: `sys/security/mac_partition/` - partitionディレクトリ確認
- E-08: `sys/security/mac_ifoff/` - ifoffディレクトリ確認
- E-09: `sys/security/mac_lomac/` - LOmacディレクトリ確認
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング（画面No.26）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TrustedBSDプロジェクトの成果 | E-01（1-11行目コメント） | ○ |
| C-02 | 3つのプログラミングインタフェース | E-01（45-67行目コメント） | ○ |
| C-03 | ポリシーモジュールのプラグイン機構 | E-01 | ○ |
| C-04 | Bibaポリシーモジュール存在 | E-02 | ○ |
| C-05 | MLSポリシーモジュール存在 | E-03 | ○ |
| C-06 | bsdextendedポリシーモジュール存在 | E-04 | ○ |
| C-07 | seeotheruidsポリシーモジュール存在 | E-05 | ○ |
| C-08 | portaclポリシーモジュール存在 | E-06 | ○ |
| C-09 | partitionポリシーモジュール存在 | E-07 | ○ |
| C-10 | ifoffポリシーモジュール存在 | E-08 | ○ |
| C-11 | lomacポリシーモジュール存在 | E-09 | ○ |
| C-12 | 画面No.26との関連 | E-11 | ○ |
| C-13 | rmlockによる保護 | E-01（80行目rmlock include） | ○ |
| C-14 | macOSセキュリティフレームワークへの影響 | 一般知識 | ○ |
| C-15 | mac_ddb, mac_do, mac_ntpd等の存在 | ディレクトリ一覧確認 | ○ |
| C-16 | mac_priority, mac_pimd等の存在 | ディレクトリ一覧確認 | ○ |
| C-17 | エラー合成演算子の具体的実装ロジック | **根拠なし** | △ |
| C-18 | 全ポリシーモジュールの完全一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- エラー合成演算子の詳細：mac_error_select()等の関数の具体的ロジック
  - 候補：mac_framework.cの深部読解 / mac_internal.h
- ポリシーモジュール完全一覧：sys/security/mac*/のすべてのディレクトリの網羅確認
  - 候補：sys/security/配下の全ディレクトリ列挙

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MACフレームワークのアーキテクチャ記述は十分な根拠あり
- 0: 低リスク - ポリシーモジュール群の存在は確認済み
- 1: 中リスク - エラー合成のエッジケース動作は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] mac_policy_ops構造体の主要エントリポイントが網羅されているか確認
- [ ] 各ポリシーモジュールの概要説明が正確か確認
- [ ] ユーザ空間API（mac_get_*/mac_set_*）の記述が正確か確認
- [ ] セキュリティ強化設定画面（画面No.26）との連携記述を確認
